/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.evolvedmekanism.multiblock.apt;

import fr.iglee42.evolvedmekanism.multiblock.apt.APTMultiblockData;
import fr.iglee42.evolvedmekanism.multiblock.apt.TileEntityAPTPort;
import fr.iglee42.evolvedmekanism.registries.EMBlockTypes;
import java.util.EnumSet;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import mekanism.common.content.blocktype.BlockType;
import mekanism.common.lib.math.voxel.VoxelCuboid;
import mekanism.common.lib.math.voxel.VoxelPlane;
import mekanism.common.lib.multiblock.CuboidStructureValidator;
import mekanism.common.lib.multiblock.FormationProtocol;
import mekanism.common.lib.multiblock.Structure;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class APTValidator
extends CuboidStructureValidator<APTMultiblockData> {
    private static final VoxelCuboid BOUNDS = new VoxelCuboid(9, 5, 9);
    private static final byte[][] ALLOWED_TOP_BOTTOM = new byte[][]{{0, 0, 0, 1, 1, 1, 0, 0, 0}, {0, 0, 1, 2, 2, 2, 1, 0, 0}, {0, 1, 2, 2, 2, 2, 2, 1, 0}, {1, 2, 2, 2, 2, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 2, 2, 2, 1}, {1, 2, 2, 2, 2, 2, 2, 2, 1}, {0, 1, 2, 2, 2, 2, 2, 1, 0}, {0, 0, 1, 2, 2, 2, 1, 0, 0}, {0, 0, 0, 1, 1, 1, 0, 0, 0}};
    private static final byte[][] ALLOWED_LAYERS = new byte[][]{{0, 0, 0, 1, 2, 1, 0, 0, 0}, {0, 0, 2, 3, 3, 3, 2, 0, 0}, {0, 2, 3, 3, 3, 3, 3, 2, 0}, {1, 3, 3, 3, 3, 3, 3, 3, 1}, {2, 3, 3, 3, 3, 3, 3, 3, 2}, {1, 3, 3, 3, 3, 3, 3, 3, 1}, {0, 2, 3, 3, 3, 3, 3, 2, 0}, {0, 0, 2, 3, 3, 3, 2, 0, 0}, {0, 0, 0, 1, 2, 1, 0, 0, 0}};

    protected FormationProtocol.StructureRequirement getStructureRequirement(BlockPos pos) {
        if ((pos = pos.m_121996_((Vec3i)this.cuboid.getMinPos())).m_123342_() == 0 || pos.m_123342_() == 4) {
            return FormationProtocol.StructureRequirement.REQUIREMENTS[ALLOWED_TOP_BOTTOM[pos.m_123341_()][pos.m_123343_()]];
        }
        return FormationProtocol.StructureRequirement.REQUIREMENTS[ALLOWED_LAYERS[pos.m_123341_()][pos.m_123343_()]];
    }

    protected FormationProtocol.CasingType getCasingType(BlockState state) {
        Block block = state.m_60734_();
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{EMBlockTypes.APT_CASING})) {
            return FormationProtocol.CasingType.FRAME;
        }
        if (BlockType.is((Block)block, (BlockType[])new BlockType[]{EMBlockTypes.APT_PORT})) {
            return FormationProtocol.CasingType.VALVE;
        }
        return FormationProtocol.CasingType.INVALID;
    }

    public boolean precheck() {
        this.cuboid = APTValidator.fetchCuboid(this.structure, BOUNDS, BOUNDS, EnumSet.allOf(VoxelCuboid.CuboidSide.class), 168);
        return this.cuboid != null;
    }

    protected boolean isFrameCompatible(BlockEntity tile) {
        if (tile instanceof TileEntityAPTPort) {
            TileEntityAPTPort port = (TileEntityAPTPort)tile;
            BlockPos posInStruct = tile.m_58899_().m_121996_((Vec3i)this.cuboid.getMinPos());
            byte requirement = 0;
            requirement = posInStruct.m_123342_() == 0 || posInStruct.m_123342_() == 4 ? ALLOWED_TOP_BOTTOM[posInStruct.m_123341_()][posInStruct.m_123343_()] : ALLOWED_LAYERS[posInStruct.m_123341_()][posInStruct.m_123343_()];
            if (requirement == 0) {
                return false;
            }
        }
        return super.isFrameCompatible(tile);
    }

    public static VoxelCuboid fetchCuboid(Structure structure, VoxelCuboid minBounds, VoxelCuboid maxBounds, Set<VoxelCuboid.CuboidSide> sides, int tolerance) {
        if (sides.size() < 2) {
            return null;
        }
        int missing = 0;
        VoxelCuboid.CuboidBuilder builder = new VoxelCuboid.CuboidBuilder();
        for (VoxelCuboid.CuboidSide side : sides) {
            Map.Entry majorEntry;
            Structure.Axis axis = side.getAxis();
            Structure.Axis horizontal = axis.horizontal();
            Structure.Axis vertical = axis.vertical();
            NavigableMap majorAxisMap = structure.getMajorAxisMap(axis);
            Map.Entry entry = majorEntry = side.getFace().isPositive() ? majorAxisMap.lastEntry() : majorAxisMap.firstEntry();
            if (majorEntry == null) {
                return null;
            }
            VoxelPlane plane = (VoxelPlane)majorEntry.getValue();
            if ((missing += plane.getMissing()) > tolerance) {
                return null;
            }
            int majorKey = (Integer)majorEntry.getKey();
            builder.set(side, majorKey);
            builder.trySet(VoxelCuboid.CuboidSide.get((VoxelCuboid.CuboidSide.Face)VoxelCuboid.CuboidSide.Face.NEGATIVE, (Structure.Axis)horizontal), plane.getMinCol());
            builder.trySet(VoxelCuboid.CuboidSide.get((VoxelCuboid.CuboidSide.Face)VoxelCuboid.CuboidSide.Face.POSITIVE, (Structure.Axis)horizontal), plane.getMaxCol());
            builder.trySet(VoxelCuboid.CuboidSide.get((VoxelCuboid.CuboidSide.Face)VoxelCuboid.CuboidSide.Face.NEGATIVE, (Structure.Axis)vertical), plane.getMinRow());
            builder.trySet(VoxelCuboid.CuboidSide.get((VoxelCuboid.CuboidSide.Face)VoxelCuboid.CuboidSide.Face.POSITIVE, (Structure.Axis)vertical), plane.getMaxRow());
            NavigableMap minorAxisMap = structure.getMinorAxisMap(axis);
            if (minorAxisMap.isEmpty() || !(side.getFace().isPositive() ? APTValidator.hasOutOfBoundsPositiveMinor(minorAxisMap, majorKey) : APTValidator.hasOutOfBoundsNegativeMinor(minorAxisMap, majorKey))) continue;
            return null;
        }
        VoxelCuboid ret = builder.build();
        if (!ret.greaterOrEqual(minBounds) || !maxBounds.greaterOrEqual(ret)) {
            return null;
        }
        return ret;
    }

    private static boolean hasOutOfBoundsNegativeMinor(NavigableMap<Integer, VoxelPlane> minorAxisMap, int majorKey) {
        int minorKey;
        Map.Entry<Integer, VoxelPlane> minorEntry = minorAxisMap.firstEntry();
        while (minorEntry != null && (minorKey = minorEntry.getKey().intValue()) < majorKey) {
            if (minorEntry.getValue().hasFrame()) {
                return true;
            }
            minorEntry = minorAxisMap.higherEntry(minorKey);
        }
        return false;
    }

    private static boolean hasOutOfBoundsPositiveMinor(NavigableMap<Integer, VoxelPlane> minorAxisMap, int majorKey) {
        int minorKey;
        Map.Entry<Integer, VoxelPlane> minorEntry = minorAxisMap.lastEntry();
        while (minorEntry != null && (minorKey = minorEntry.getKey().intValue()) > majorKey) {
            if (minorEntry.getValue().hasFrame()) {
                return true;
            }
            minorEntry = minorAxisMap.lowerEntry(minorKey);
        }
        return false;
    }
}

